/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import net.java.dev.designgridlayout.MultiComponent;

final class ComponentGapsHelper {
    private final LayoutStyle _style = LayoutStyle.getInstance();
    private int _indent = -1;

    ComponentGapsHelper() {
    }

    public static ComponentGapsHelper instance() {
        return new ComponentGapsHelper();
    }

    public int getHorizontalIndent() {
        if (this._indent == -1) {
            JLabel label1 = new JLabel("Top label");
            JLabel label2 = new JLabel("Bottom label");
            this._indent = this._style.getPreferredGap(label1, label2, LayoutStyle.ComponentPlacement.INDENT, 5, null);
        }
        return this._indent;
    }

    public int getVerticalGap(JComponent component1, JComponent component2, LayoutStyle.ComponentPlacement type, Container parent) {
        if (component1 instanceof MultiComponent) {
            MultiComponent multi2 = (MultiComponent)component1;
            int gap = 0;
            for (JComponent child : multi2.getChildren()) {
                gap = Math.max(gap, this.getVerticalGap(child, component2, type, parent));
            }
            return gap;
        }
        if (component2 instanceof MultiComponent) {
            MultiComponent multi3 = (MultiComponent)component2;
            int gap = 0;
            for (JComponent child : multi3.getChildren()) {
                gap = Math.max(gap, this.getVerticalGap(component1, child, type, parent));
            }
            return gap;
        }
        return this._style.getPreferredGap(component1, component2, type, 5, parent);
    }

    public int getHorizontalGap(JComponent component1, JComponent component2, LayoutStyle.ComponentPlacement type, Container parent) {
        if (component1 instanceof MultiComponent) {
            MultiComponent multi2 = (MultiComponent)component1;
            int size2 = multi2.getChildren().length;
            return size2 == 0 ? 0 : this.getHorizontalGap(multi2.getChildren()[size2 - 1], component2, type, parent);
        }
        if (component2 instanceof MultiComponent) {
            MultiComponent multi3 = (MultiComponent)component2;
            int size3 = multi3.getChildren().length;
            return size3 == 0 ? 0 : this.getHorizontalGap(component1, multi3.getChildren()[0], type, parent);
        }
        return this._style.getPreferredGap(component1, component2, type, 3, parent);
    }

    public int getNorthContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi2 = (MultiComponent)component;
            int gap = 0;
            for (JComponent child : multi2.getChildren()) {
                gap = Math.max(gap, this.getNorthContainerGap(child, parent));
            }
            return gap;
        }
        return this._style.getContainerGap(component, 1, parent);
    }

    public int getSouthContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi2 = (MultiComponent)component;
            int gap = 0;
            for (JComponent child : multi2.getChildren()) {
                gap = Math.max(gap, this.getSouthContainerGap(child, parent));
            }
            return gap;
        }
        return this._style.getContainerGap(component, 5, parent);
    }

    public int getWestContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi2 = (MultiComponent)component;
            if (multi2.getChildren().length > 0) {
                return this.getWestContainerGap(multi2.getChildren()[0], parent);
            }
            return 0;
        }
        return this._style.getContainerGap(component, 7, parent);
    }

    public int getEastContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi2 = (MultiComponent)component;
            int size2 = multi2.getChildren().length;
            if (size2 > 0) {
                return this.getEastContainerGap(multi2.getChildren()[size2 - 1], parent);
            }
            return 0;
        }
        return this._style.getContainerGap(component, 3, parent);
    }
}

